<?php

/**
 * BaseEmployeeMembership
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $empNumber
 * @property integer $membershipId
 * @property decimal $subscriptionFee
 * @property string $subscriptionPaidBy
 * @property string $subscriptionCurrency
 * @property date $subscriptionCommenceDate
 * @property date $subscriptionRenewalDate
 * @property Membership $Membership
 * @property Employee $Employee
 * 
 * @method integer            getEmpNumber()                Returns the current record's "empNumber" value
 * @method integer            getMembershipId()             Returns the current record's "membershipId" value
 * @method decimal            getSubscriptionFee()          Returns the current record's "subscriptionFee" value
 * @method string             getSubscriptionPaidBy()       Returns the current record's "subscriptionPaidBy" value
 * @method string             getSubscriptionCurrency()     Returns the current record's "subscriptionCurrency" value
 * @method date               getSubscriptionCommenceDate() Returns the current record's "subscriptionCommenceDate" value
 * @method date               getSubscriptionRenewalDate()  Returns the current record's "subscriptionRenewalDate" value
 * @method Membership         getMembership()               Returns the current record's "Membership" value
 * @method Employee           getEmployee()                 Returns the current record's "Employee" value
 * @method EmployeeMembership setEmpNumber()                Sets the current record's "empNumber" value
 * @method EmployeeMembership setMembershipId()             Sets the current record's "membershipId" value
 * @method EmployeeMembership setSubscriptionFee()          Sets the current record's "subscriptionFee" value
 * @method EmployeeMembership setSubscriptionPaidBy()       Sets the current record's "subscriptionPaidBy" value
 * @method EmployeeMembership setSubscriptionCurrency()     Sets the current record's "subscriptionCurrency" value
 * @method EmployeeMembership setSubscriptionCommenceDate() Sets the current record's "subscriptionCommenceDate" value
 * @method EmployeeMembership setSubscriptionRenewalDate()  Sets the current record's "subscriptionRenewalDate" value
 * @method EmployeeMembership setMembership()               Sets the current record's "Membership" value
 * @method EmployeeMembership setEmployee()                 Sets the current record's "Employee" value
 * 
 * @package    orangehrm
 * @subpackage model\pim\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployeeMembership extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_emp_member_detail');
        $this->hasColumn('emp_number as empNumber', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('membship_code as membershipId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             ));
        $this->hasColumn('ememb_subscript_amount as subscriptionFee', 'decimal', 15, array(
             'type' => 'decimal',
             'scale' => false,
             'length' => 15,
             ));
        $this->hasColumn('ememb_subscript_ownership as subscriptionPaidBy', 'string', 30, array(
             'type' => 'string',
             'default' => '',
             'length' => 30,
             ));
        $this->hasColumn('ememb_subs_currency as subscriptionCurrency', 'string', 13, array(
             'type' => 'string',
             'default' => '',
             'length' => 13,
             ));
        $this->hasColumn('ememb_commence_date as subscriptionCommenceDate', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
        $this->hasColumn('ememb_renewal_date as subscriptionRenewalDate', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Membership', array(
             'local' => 'membershipId',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));
    }
}